 ; Ŀ
 ;   Defile - update detail balloons to reference the correct drawing.     
 ;   Copyright 1991, 1995, 2005, 2007, 2008 by Rocket Software Ltd.        
 ;   Finds detail to file mapping in the file Details.txt in the           
 ;   directory containing the drawings.                                    
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutin Bliz - place a flake marker.                                
 ; 
 (DEFUN BLIZ (cen len colo ang / ang end pa pb pc pa1 pb1 pc1)
  (repeat 6
          (setq ang (+ ang (/ pi 3)))
          (setq end (polar cen (+ ang (/ pi 2)) (* len 0.5)))
          (setq pa (polar cen (+ ang (* pi (/ 2 3.0))) (* len 0.242873)))
          (setq pb (polar cen (+ ang (/ pi 2)) (* len 0.096394)))
          (setq pc (polar cen (+ ang (/ pi 3)) (* len 0.242873)))
          (setq pa1 (polar cen (+ ang (* (/ 106.63 180) pi)) (* len 0.433656)))
          (setq pb1 (polar cen (+ ang (/ pi 2)) (* len 0.299070)))
          (setq pc1 (polar cen (+ ang (* (/ 73.3699 180) pi))
                                      (* len 0.433656)))
          (grdraw cen end colo)
          (grdraw pa pb colo)
          (grdraw pb pc colo)
          (grdraw pa1 pb1 colo)
          (grdraw pb1 pc1 colo))
 (princ))
 ; Ŀ
 ;   Bliz end.                                                             
 ; 

 ; Ŀ
 ;   Dilate - update a detail block.                                       
 ;   Arguments: Enam, a block insertion entity name.                       
 ;              Liz, a list: ((detail_name  drawing) ...).                 
 ;   Calls nothing.                                                        
 ;   Returns nothing.                                                      
 ;   Chews gum.                                                            
 ;   Blows large pink bubbles.                                             
 ; 
 (DEFUN DILATE (enam liz / esav pa astr nustr)
  (setq esav enam)
  (setq pa (cdr (assoc 10 (entget esav))))
  (setq astr (cdr (assoc 1 (entget (setq enam (entnext enam))))))
  (setq rad (/ (getvar "viewsize") 20))
  (if (setq nustr (cadr (assoc astr liz)))
      (progn
           (setq asoc1 (assoc 1 (setq entt (entget (entnext enam)))))
           (entmod (subst (cons 1 nustr) asoc1 entt))
           (entupd esav)
           (bliz pa rad 3 0))
      (progn
           (write-line "* Missing Detail Name *")
           (bliz pa (* rad 1.25) 160 0)
           (bliz pa (* rad 1.5) 20 (/ pi 6.0))))
 (princ))
 ; Ŀ
 ;   Dilate end.                                                           
 ; 

 ; Ŀ
 ;   Flout - suck a text file into a list of lists of strings.             
 ;   Arguments: filnam, a filename.                                        
 ;   Calls Sub1.                                                           
 ;   Returns a list: (("up-to-first-comma" "rest") ... )                   
 ;   If there is no comma then the sublist is: ("string" "").              
 ; 
 (DEFUN FLOUT (filnam / fn linn malist)
  (if (setq fn (open filnam "r"))
      (progn
           (while (setq linn (read-line fn))
                  (if (/= linn "")
                      (setq malist (append malist (list (sub1 linn))))))
           (close fn)))
 malist)
 ; Ŀ
 ;   Flout end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Sub1 - split a text string at the first comma.             
 ;   Argument: Linn, a text string.                                        
 ;   Returns a list of substrings.                                         
 ;   If there is no comma in the string returns ("string" "").             
 ; 
 (DEFUN SUB1 (linn / len pos name1 strlst)
  (setq pos 1)
  (setq len (strlen linn))
  (while (and (/= (substr linn pos 1) ",")
              (>= len pos))
         (setq pos (1+ pos)))
  (setq name1 (substr linn 1 (1- pos)))
  (setq linn (substr linn (1+ pos)))
 (list name1 linn))
 ; Ŀ
 ;   Sub1 end.                                                             
 ; 

 ; Ŀ
 ;   Defile.                                                               
 ; 
 (DEFUN C:DEFILE (/ filnam *error* lista filnam)
  (setvar "cmdecho" 0)
  (setq filnam (strcat (getvar "dwgprefix") "Details.txt"))
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Read the data from the file details.txt into a list.                  
 ;   This should probably be updated to climb.  Maybe.                     
 ; 
  (setq lista (flout filnam))
 ; Ŀ
 ;   Get an ss of all detail tag blocks in the drawing.                    
 ; 
  (setq ss (ssget "x" (list (cons 2 "dettag*"))))
 ; Ŀ
 ;   Update the second attribute in each block depending on the value      
 ;   of the first.                                                         
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (dilate enam lista))
 (princ))